/*
*	jQuery getTweets v1.1
*	written by Alexander Sklepas
*
*	Copyright (c) 2013 Sklepas Alexandros (http://www.digi-web.gr/)
*	Dual licensed under the MIT (mit.txt)
*	and GPL (gpl.txt) licenses.
*	Built using jQuery library 
*
*	Options:
*		- before (string): HTML code before the tweet.
*		- after (string): HTML code after the tweet.
*		- tweets (numeric): Maximun number of tweets to display.
*	
*	Example: 
*	
*		<script type="text/javascript" charset="utf-8">
*   		$(document).ready(function() {
*      			$('#getTweets').getTweets({
*       			tweets:5,
*					key: 'BaqRhGUU7BwlPjO1sQ5H8w',
*					keysec: 'tnrLnA53W1cESxkvlr9vkIWqXXXXXXXXXX,
*					token: '519748211-DMhkgVPgVKPYq3tYjUVP5Pd6E1OaVth5n2zBZ6Hi',
*					tokensec: 'J92YlL0O8wjIpUA1kMO4ZhIXXXXXXXXXXX'
*      			});
*  			});
*		</script>
*
*/
(function($){
	$.fn.getTweets = function(options) {
	var defaults = {
		tweets: 5,
		before: '<li>',
		after: '</li>',
		key: '',
		keysec: '',
		token: '',
		tokensec: ''
	};
	var options = $.extend(defaults, options);
	
	var cb = new Codebird;
	//cb.setConsumerKey('YOURKEY', 'YOURSECRET');
	cb.setConsumerKey(options.key, options.keysec);
	
	//cb.setToken('YOURTOKEN', 'YOURTOKENSECRET');
	cb.setToken(options.token, options.tokensec);
	
		return this.each(function() {
		var obj = $(this);
		
			cb.__call(
				'statuses/userTimeline',
				{count: options.tweets},
				function (reply) {
					$.each(reply, function(i, tweet) {
						if(tweet.text !== undefined) {
							//split text into href and comment part
							var tweethref= tweet.text.split(" ",1);
							$(obj).append(options.before+'<a class="external" href="'+tweethref+'">'+tweet.text+'</a>'+options.after);
						}
					});
					//console.log(reply);
				}
			);
		});
	};
})(jQuery);