<?php	
	/*
	Text into image script
	Original Consept by Terri Ann http://terriswallow.com
	Created by Alex Sklepas
	Version 1.1
	Date: 04 2012
	Web site www.digi-web.gr
	Requirements 	GD lib support
	*/
	
	//Default Values Setup
	
	$dir 			= "cache"; // Change the Cache folder name if you wish, do not put / at the end of the path 
	$font_file 		= 'ambient.ttf';
	$font_size  	= 24; 
	$font_color 	= '#000';
	$x_finalpos 	= 50;
	$y_finalpos 	= 50;
	$image_file		= ""; // this is the image file path/name
	$save_file		= false; //switch to save the file cache / no need to have a value
	$create_dir 	= true; // Create cache dir if it doesnt exist / some server setups might not have the write user rights for this command to work
	
	/*
	The script takes as input the following REQUEST vars
	
	text 			The text you wish to embed into the image
	size			The font size in pts - default 24
	color 			The color in web format like #000 or #000111
	image			The image path relative to the script position
	x				The x axis for the text default 50
	y				The y axis for the text default 50
	save			saves the image in cache folder - usable when save_file is false
	*/
	
	if($create_dir == true)
	{
		if( !file_exists($dir) )
		{
			if(!mkdir("".$dir."", 0777, true))
			{
				throw_error('Error: Failed to create cache folder') ;
			}
		}
	}

	if(empty($_REQUEST['text']))	throw_error('Error: No text specified.') ;
		
	$text = html_entity_decode($_REQUEST['text']).'' ;
	$textpath = $text;

	if(empty($text))		throw_error('Error: Text not properly formatted.') ;

	if($_REQUEST['size'])
	{
		$font_size = html_entity_decode($_REQUEST['size']) ;
		$textpath .= "_".$font_size."";
	}
	
	if($_REQUEST['color'])
	{
		$font_color = html_entity_decode($_REQUEST['color']);
	}
	
	if(empty($image_file)) $image_file = html_entity_decode($_REQUEST['image']);
	
	if(empty($image_file) || !file_exists($image_file)) throw_error('Error: No valid image is given. Please check the image path') ;
	
	if( (isset($_REQUEST['x'])) && (strlen($_REQUEST['x'])) )
	{
		$x_finalpos = html_entity_decode($_REQUEST['x']);
		$textpath .= "_".$x_finalpos."";
	}
	if( (isset($_REQUEST['y'])) && (strlen($_REQUEST['y'])) )
	{
		$y_finalpos = html_entity_decode($_REQUEST['y']);
		$textpath .= "_".$y_finalpos."";
	}
	if( (isset($_REQUEST['save'])) )
	{
		$save_file = true;
	}	
	
	// image types supported
	$img_array = array("png","jpg","gif");
	
	//get file extension
	$extension = end(explode('.', $image_file));

	if( in_array($extension, $img_array))
	{
		switch($extension)
		{
			case "png":
				$mime_type 	= 'image/png' ;
				$image =  imagecreatefrompng($image_file);
			break;
			case "jpg":
				$mime_type 	= 'image/jpeg' ;
				$image =  imagecreatefromjpeg($image_file);
			break;
			case "gif":
				$mime_type 	= 'image/gif' ;
				$image =  imagecreatefromgif($image_file);
			break;
		}

	}else{
		throw_error('Error: Server does not support this type of image') ;
	}

	$s_end_buffer_size 	= 4096 ;


	// check for GD support
	
	if(!function_exists('ImageCreate'))

		throw_error('Error: Server does not support PHP image generation') ;

	// check font availability;

	if(!is_readable($font_file))

		throw_error('Error: The server is missing the specified font.') ;

	// create and measure the text

	$font_rgb = hex_to_rgb($font_color) ;

	$box = @ImageTTFBBox($font_size,0,$font_file,$text) ;

	$text_width = abs($box[2]-$box[0]);

	$text_height = abs($box[5]-$box[3]);

	if(!$image || !$box)
	{
		throw_error('Error: The server could not create this image "'.$image_file.'" -'.strlen($image_file).'');
	}

	// allocate colors and measure final text position
	$font_color = ImageColorAllocate($image,$font_rgb['red'],$font_rgb['green'],$font_rgb['blue']) ;
	$image_width = imagesx($image);
	$put_text_x = $image_width - $text_width - ($image_width - $x_finalpos);
	$put_text_y = $y_finalpos;

	// Write the text
	imagettftext($image, $font_size, 0, $put_text_x,  $put_text_y, $font_color, $font_file, $text);
	header('Content-type: ' . $mime_type);

    //Generate cachefile for image, if it doesn't exist
	$cachefile = $dir.'/'.$textpath.'-tmpcache.'.$extension.'';

	/* The code to dynamically generate the page goes here */
	if( !file_exists($cachefile) ) 
	{
	
	ob_start(); // Start the output buffer
	
	if($save_file)
	{
	$fp = fopen($cachefile, 'w');
	}
	
	switch($extension)
	{
		case "png":
			imagepng($image);
		break;
		case "jpg":
			imagejpeg($image);
		break;
		case "gif":
			imagegif($image);
		break;
	}
	
	if($save_file)
	{
		fwrite($fp, ob_get_contents());
		fclose($fp);
	}
	
	ob_end_flush(); // Send the output to the browser
	imagedestroy($image);

	}
	
	$fp = fopen($cachefile, 'rb'); # stream the image directly from the cachefile
	if(!$fp)
	{
		$fp = file_get_contents($cachefile); 
	}

	fpassthru($fp);
	exit;

	/*
		attempt to create an image containing the error message given. 
		if this works, the image is sent to the browser. if not, an error
		is logged, and passed back to the browser as a 500 code instead.
	*/

	function throw_error($message)
	{

		// send an image
		if(function_exists('ImageCreate'))
		{

			$width = ImageFontWidth(5) * strlen($message) + 10 ;
			$height = ImageFontHeight(5) + 10 ;

			if($image = ImageCreate($width,$height))
			{

				$background = ImageColorAllocate($image,255,255,255) ;
				$text_color = ImageColorAllocate($image,0,0,0) ;
				imagestring($image,5,5,5,$message,$text_color) ;    
				header('Content-type: image/jpeg') ;
				imagejpeg($image) ;
				imagedestroy($image) ;
				exit ;

			}

		}

		// send 500 code
		header("HTTP/1.0 500 Internal Server Error") ;
		print($message) ;
		exit ;

	}

	/* 
		decode an HTML hex-code into an array of R,G, and B values.
		accepts these formats: (case insensitive) #ffffff, ffffff, #fff, fff 
	*/    

	function hex_to_rgb($hex) {

		if(substr($hex,0,1) == '#')

			$hex = substr($hex,1) ;

		// expand short form ('fff') color to long form ('ffffff')

		if(strlen($hex) == 3) {

			$hex = substr($hex,0,1) . substr($hex,0,1) .
				   substr($hex,1,1) . substr($hex,1,1) .
				   substr($hex,2,1) . substr($hex,2,1) ;

		}


		if(strlen($hex) != 6)

			throw_error('Error: Invalid color "'.$hex.'"') ;

		// convert from hexidecimal number systems
		$rgb['red'] = hexdec(substr($hex,0,2)) ;
		$rgb['green'] = hexdec(substr($hex,2,2)) ;
		$rgb['blue'] = hexdec(substr($hex,4,2)) ;

		return $rgb ;

	}

?>